//////////////////////////////////////////////
//	Export Dialog class
class CExportDialog: public CDialog
{
	CButton*	pStandart;
	CButton*	pDash;
	CButton*	pTrailer;
	CButton*	pMultiple;
	CButton*	pAdd;
	CButton*	pRemove;

	CEdit*		pDefault;
	CEdit*		pCurrent;
	CListBox*	pList;
public:
	long	Choice;		//type
	long	NumPaintjobs;
	CString	DefSuffix;
	CString	Suffixes[10];

	CExportDialog(CWnd* pwnd):CDialog(IDD_EXPORTDIALOG, pwnd){};

	BOOL	OnInitDialog();


	afx_msg void OnStandart();
	afx_msg void OnDash();
	afx_msg void OnTrailer();
	afx_msg void OnMultiple();
	afx_msg void OnAdd();
	afx_msg void OnRemove();

	afx_msg void OnSelChange();

	afx_msg void OnExport();

	DECLARE_MESSAGE_MAP()
};


BEGIN_MESSAGE_MAP(CExportDialog, CDialog)
	ON_BN_CLICKED(IDC_STANDARTRADIO, OnStandart)
	ON_BN_CLICKED(IDC_DASHRADIO, OnDash)
	ON_BN_CLICKED(IDC_TRAILERRADIO, OnTrailer)
	ON_BN_CLICKED(IDC_MULTIPLECHECK, OnMultiple)

	ON_BN_CLICKED(IDC_ADDBUTTON, OnAdd)
	ON_BN_CLICKED(IDC_REMOVEBUTTON, OnRemove)

	ON_LBN_SELCHANGE(IDC_SUFFIXESLIST, OnSelChange)

	ON_BN_CLICKED(IDOK, OnExport)
END_MESSAGE_MAP()



BOOL CExportDialog::OnInitDialog()
{
  CDialog::OnInitDialog();
	pStandart	= (CButton*)GetDlgItem(IDC_STANDARTRADIO);
	pDash		= (CButton*)GetDlgItem(IDC_DASHRADIO);
	pTrailer	= (CButton*)GetDlgItem(IDC_TRAILERRADIO);

	pMultiple	= (CButton*)GetDlgItem(IDC_MULTIPLECHECK);
	pAdd		= (CButton*)GetDlgItem(IDC_ADDBUTTON);
	pRemove		= (CButton*)GetDlgItem(IDC_REMOVEBUTTON);

	pDefault	= (CEdit*)GetDlgItem(IDC_DEFAULTSUFFEDIT);
	pCurrent	= (CEdit*)GetDlgItem(IDC_SUFFEDIT);

	pList		= (CListBox*)GetDlgItem(IDC_SUFFIXESLIST);

	OnStandart();
	OnMultiple();

	pDefault->SetWindowText("_white");
	pCurrent->SetWindowText("_blue");
	pList->AddString("_blue");

  CurrentState.CurrentParams.sysp(Z3D_REQUEST_LOCALIZE_USER_DIALOG, NULL,
      "Filters\\PKG", (long*)this, NULL);
	
	return TRUE;
}




afx_msg void CExportDialog::OnStandart()
{
	pStandart	->SetCheck(1);
	pDash		->SetCheck(0);
	pTrailer	->SetCheck(0);
	Choice = 0;
}

afx_msg void CExportDialog::OnDash()
{
	pStandart	->SetCheck(0);
	pDash		->SetCheck(1);
	pTrailer	->SetCheck(0);
	Choice = 1;
}


afx_msg void CExportDialog::OnTrailer()
{
	pStandart	->SetCheck(0);
	pDash		->SetCheck(0);
	pTrailer	->SetCheck(1);
	Choice = 2;
}


afx_msg void CExportDialog::OnMultiple()
{
	BOOL	bEnabled = (pMultiple->GetCheck() == 1);

	pAdd->EnableWindow(bEnabled);
	pRemove->EnableWindow(bEnabled);
	pDefault->EnableWindow(bEnabled);
	pCurrent->EnableWindow(bEnabled);
	pList->EnableWindow(bEnabled);
	
	pList->SetSel(0);
	OnSelChange();
}

afx_msg void CExportDialog::OnAdd()
{
	CString str;
	pCurrent->GetWindowText(str);
	if (pList->GetCount() >= 10) return;

	if (pList->FindStringExact(-1, str) == LB_ERR)
		pList->AddString(str);
	pList->SetSel(0);
	OnSelChange();
}

afx_msg void CExportDialog::OnRemove()
{
	pList->DeleteString(pList->GetCurSel());
	OnSelChange();
}

afx_msg void CExportDialog::OnSelChange()
{
	CString str;
	pRemove->EnableWindow((pList->GetCount() > 0));
	if (pList->GetCurSel() < 0)
		pList->SetCurSel(0);
	if (pList->GetCurSel() >= 0)
	{
		pList->GetText(pList->GetCurSel(), str);
		pCurrent->SetWindowText(str);
	}
}

afx_msg void CExportDialog::OnExport()
{
	NumPaintjobs = pList->GetCount();
	if (pMultiple->GetCheck() == 0)
		NumPaintjobs = 0;

	for (int i = 0; i < NumPaintjobs; i++)
		pList->GetText(i, Suffixes[i]);
	
	pDefault->GetWindowText(DefSuffix);
	EndDialog(IDOK);
}
